%% load data

load MSCI_data
warning off all

d=5;  %dimension to consider

%r=1;  %forecast horizon (may be used later)
%compute returns
Y=(log(data(2:end,:))-log(data(1:end-1,:)))*100;   
Y_full=Y(:,1:d);

%to store the results
Tests_N=[];
Tests_KS=[];
Tests_K=[];
Per_tests_N=[];
Per_tests_KS=[];
Per_tests_K=[];

for period=2:9
%period of choice
if period==1
    first=835;
    last=1043;
elseif period==2
    first=1044;
    last=1252;
elseif period==3
    first=1253;
    last=1460;    
elseif period==4
    first=1461;
    last=1669;
elseif period==5
    first=1670;
    last=1878;       
elseif period==6
    first=1879;
    last=2087;    
elseif period==7
    first=2088;
    last=2295;
elseif period==8
    first=2296;
    last=2504;
elseif period==9   %this case is for the full-sample analysis
    first=835;
    last=2504;    
end  
    
    
    
    
%sample size, in-sample and out-of-sample
Y=Y_full(first-521:last,:);  %10-years for model estimation
T=size(Y,1);
Toos=last-first+1;     %always 4 years out-of-sample data (except for full sample case 9)
T_is=T-Toos;

%the stuff I need to store to compute our tests
U_oos=zeros(Toos,d);
X_oos=zeros(Toos,d);
nu_oos=zeros(Toos,1);
U_oos_pit=zeros(Toos,d);
R_oos=zeros(d,d,Toos);
scores_oos=zeros(Toos,6*d+3);  %to safe the scores

parfor k=1:Toos;

Y_is=Y(1:(T_is+k-1),:);
Y_is=Y_is-repmat(mean(Y_is),T_is+k-1,1);
%Y_is=Y(1+k-1:(T_is+k-1),:);   %the in-sample data
    
%estimate the marginal GJR-skewed-t-GARCH models and make Uniforms
garchparam=zeros(6,d);
ht=zeros(T_is+k-1,d);
U=zeros(T_is+k-1,d);
% ht=zeros(T_is,d);
% U=zeros(T_is,d);


ht_fc=zeros(1,d);

for i=1:d
    [garchparam(:,i),~,ht(:,i),ht_fc(i)]=tarch(Y_is(:,i),1,1,1,'SKEWT',2);
    nu=min(garchparam(end-1,i),200);
    lambda=garchparam(end,i);
    U(:,i)=skewtcdf((Y_is(:,i)./sqrt(ht(:,i))),nu,lambda);
end

%DCC Student model
[CopParams, Rt, veclRt, LogL, OptInfo]=EstimateTVTCopula(U,'DCC','fmincon','IFM');


    %now forecasting
    U_fc=zeros(T_is+k,d);         
    %U_fc=zeros(T_is+1,d); 
        

    %obtain 1-step forecasts  (for multi-step forecasts use code from 'forecast_script_DCC')
    for i=1:d
        var_fc=[ht(:,i)' ht_fc(i)]';  
        nu=min(garchparam(end-1,i),200);
        lambda=garchparam(end,i);
        U_fc(:,i)=skewtcdf(([Y_is(1:end,i)' Y(T_is+k,i)]'./sqrt(var_fc)),nu,lambda);
        %U_fc(:,i)=skewtcdf((Y(1+k-1:T_is+k,i)./sqrt(var_fc)),nu,lambda);
    end;
    [LogL,Rt,veclRt]=TCopulaLogLikhood(CopParams,U_fc,'DCC','fmincon','IFM');
    R_fc=Rt(:,:,end);
    R_oos(:,:,k)=R_fc;
    %and now the Rosenblatt transform for the copula
    nu=CopParams(1);
    X=tinv(U_fc(end,:),nu);
    X(isinf(X))=-10;
    [~, U_oos_pit(k,:)]=PIT_Z2_student(X,R_fc,nu);
    U_oos(k,:)=U_fc(end,:);
    X_oos(k,:)=X;
    nu_oos(k)=nu;


% compute the scores (adapting code from 'robustvcv')
scoretmp=[];
m=1;
for j=1:d
epsilon=[Y_is(1:end,j)' Y(T_is+k,j)]';

%backcast step from Sheppard
    %fepsilon is f(epsilon), as above
    fepsilon   =  [mean(epsilon.^2)*ones(m,1) ; epsilon.^2];
    %fIepsilon is fepsilon*(epsilon<0)
    fIepsilon   =  [0.5*mean(epsilon.^2)*ones(m,1) ; epsilon.^2.*(epsilon<0)];
    % Local back casting
    back_cast_length = max(floor(length(epsilon)^(1/2)),1);
    back_cast_weights = .05*(.9.^(0:back_cast_length ));
    back_cast_weights = back_cast_weights/sum(back_cast_weights);
    back_cast = back_cast_weights*((epsilon(1:back_cast_length+1)).^2);
    if back_cast==0
        back_cast=mean(epsilon.^2);
    end

epsilon_augmented=[zeros(m,1);epsilon];
%Compute the length of the augmented epsilon
T     = size(fepsilon,1);



theta=garchparam(:,j);
kk=length(theta);
h=max(abs(theta*eps^(1/3)),1e-8);
h=diag(h);

[~,like]=feval('tarch_likelihood',theta,epsilon_augmented,fepsilon,fIepsilon,1,1,1,4,2,back_cast,T);

t=length(like);

likep=zeros(t,kk);
likem=zeros(t,kk);
for i=1:kk
    thetaph=theta+h(:,i);
    [~,likep(:,i)]=feval('tarch_likelihood',thetaph,epsilon_augmented,fepsilon,fIepsilon,1,1,1,4,2,back_cast,T);
    thetamh=theta-h(:,i);
    [~,likem(:,i)]=feval('tarch_likelihood',thetamh,epsilon_augmented,fepsilon,fIepsilon,1,1,1,4,2,back_cast,T);
end

scores=zeros(t,kk);
gross_scores=zeros(kk,1);
h=diag(h);
for i=1:kk
    scores(:,i)=(likep(:,i)-likem(:,i))./(2*h(i));
end


scoretmp=[scoretmp scores(end,:)];
end


%now get the score for the copula by adapting the code
T=T-1;
parameters=CopParams;
h=max(abs(parameters/2),1e-2)*eps^(1/3);
   hplus=parameters+h;
   hminus=parameters-h;
   likelihoodsplus=zeros(T,length(parameters));
   likelihoodsminus=zeros(T,length(parameters));
   for i=1:length(parameters)
      hparameters=parameters;
      hparameters(i)=hplus(i);
      [~,~,~,indivlike] = TCopulaLogLikhood(hparameters,U_fc,'DCC','fmincon','IFM');
      likelihoodsplus(:,i)=indivlike;
   end
   for i=1:length(parameters)
      hparameters=parameters;
      hparameters(i)=hminus(i);
      [~,~,~,indivlike] = TCopulaLogLikhood(hparameters,U_fc,'DCC','fmincon','IFM');
      likelihoodsminus(:,i)=indivlike;
   end
   scores=(likelihoodsplus-likelihoodsminus)./(2*repmat(h',T,1));
   scores=scores-repmat(mean(scores),T,1);

scoretmp=[scoretmp scores(end,:)];


 
scores_oos(k,:)=scoretmp;    

end

%now perform the tests

%first the easy to compute ones
P=U_oos_pit(:,1);
P_star=U_oos_pit(:,1)-0.5;
U_DHT=U_oos_pit(:,1);
Z2=norminv(U_oos_pit(:,1)).^2;
for i=2:d
    U_DHT=[U_DHT' U_oos_pit(:,i)']';
    P=P.*U_oos_pit(:,i);
    P_star=P_star.*(U_oos_pit(:,i)-0.5);
    Z2=Z2+norminv(U_oos_pit(:,i)).^2;
end

U_Z2=chi2cdf(Z2,d);
%PIT for Clements-Smith and Ko-Park
U_CS=CS_PIT(P,d);
U_KP=KP_PIT(P_star,d);



%now our tests
    %Z2_star and Z2_dag are outsourced to another function 
    [Z2_star U_star]=Z2star_Student(X_oos,R_oos,nu_oos);
    [Z2_dag U_dag]=Z2dag_Student(X_oos,R_oos,nu_oos);
    
    %Now the PITs, outsourced to separate functions
    [U_Z2_dag]=PIT_Z2dag_Student(Z2_dag,R_oos,nu_oos);
    [U_Z2_star]=PIT_Z2star_Student(Z2_star,R_oos,nu_oos);
    
    
lambda=Toos/T_is; 
[P_Z2_star]= NST_EU_DM(U_Z2_star,scores_oos',lambda,2);
[P_Z2_dag]= NST_EU_DM(U_Z2_dag,scores_oos',lambda,2);
[P_Z2]= NST_EU_DM(U_Z2,scores_oos',lambda,2);
[P_CS]= NST_EU_DM(U_CS,scores_oos',lambda,2);
[P_KP]= NST_EU_DM(U_KP,scores_oos',lambda,2);
[P_DHT]= NST_EU_DM(U_DHT,repmat(scores_oos',1,d),lambda*d,2);

Tests_N=[Tests_N; P_DHT P_CS P_KP P_Z2 P_Z2_star P_Z2_dag]


%now all the different permutations
%Y_oos=Y(end-Toos+1:end,:);
D=(1:d);
Perm = perms(D);  %all possible permutations (gets very large for large d, do not use d>10, best only up to d=8 -> 40320 permutations)
K=size(Perm,1);

Pvals=zeros(K,4);  %store the p-values here
Pvals_K=zeros(K,4);     


for k=1:K  %go through all permutations of the data

X=X_oos(:,Perm(k,:));
R0=R_oos(Perm(k,:),Perm(k,:),:);   %covariance for that week

[~, U_oos_pit]=PIT_Z2_student(X,R0,nu_oos);

%first the easy to compute ones
P=U_oos_pit(:,1);
P_star=U_oos_pit(:,1)-0.5;
U_DHT=U_oos_pit(:,1);
Z2=norminv(U_oos_pit(:,1)).^2;
for i=2:d
    U_DHT=[U_DHT' U_oos_pit(:,i)']';
    P=P.*U_oos_pit(:,i);
    P_star=P_star.*(U_oos_pit(:,i)-0.5);
    Z2=Z2+norminv(U_oos_pit(:,i)).^2;
end

U_Z2=chi2cdf(Z2,d);

U_CS=CS_PIT(P,d);
U_KP=KP_PIT(P_star,d);
[Pvals(k,1)]= NST_EU_DM(U_DHT,repmat(scores_oos',1,d),lambda*d,2);
[Pvals(k,2)]= NST_EU_DM(U_CS,scores_oos',lambda,2);
[Pvals(k,3)]= NST_EU_DM(U_KP,scores_oos',lambda,2);
[Pvals(k,4)]= NST_EU_DM(U_Z2,scores_oos',lambda,2);



end

Per_tests_N=[Per_tests_N; min(Pvals(:,1)) max(Pvals(:,1)) mean(Pvals(:,1)>0.05) ...
    min(Pvals(:,2)) max(Pvals(:,2)) mean(Pvals(:,2)>0.05) min(Pvals(:,3)) max(Pvals(:,3)) mean(Pvals(:,3)>0.05)...
    min(Pvals(:,4)) max(Pvals(:,4)) mean(Pvals(:,4)>0.05)]

end


